import { Interface } from '@ethersproject/abi';
import { BigNumberish } from 'ethers';
import { MethodParameters, Position as V3Position, RemoveLiquidityOptions as V3RemoveLiquidityOptions } from '@uniswap/v3-sdk';
import { Position as V4Position, AddLiquidityOptions as V4AddLiquidityOptions } from '@uniswap/v4-sdk';
import { Trade as RouterTrade } from '@uniswap/router-sdk';
import { Currency, TradeType } from '@uniswap/sdk-core';
import { SwapOptions } from './entities/actions/uniswap';
export declare type SwapRouterConfig = {
    sender?: string;
    deadline?: BigNumberish;
};
export interface MigrateV3ToV4Options {
    inputPosition: V3Position;
    outputPosition: V4Position;
    v3RemoveLiquidityOptions: V3RemoveLiquidityOptions;
    v4AddLiquidityOptions: V4AddLiquidityOptions;
}
export declare abstract class SwapRouter {
    static INTERFACE: Interface;
    static swapCallParameters(trades: RouterTrade<Currency, Currency, TradeType>, options: SwapOptions): MethodParameters;
    /**
     * Builds the call parameters for a migration from a V3 position to a V4 position.
     * Some requirements of the parameters:
     *   - v3RemoveLiquidityOptions.collectOptions.recipient must equal v4PositionManager
     *   - v3RemoveLiquidityOptions.liquidityPercentage must be 100%
     *   - input pool and output pool must have the same tokens
     *   - V3 NFT must be approved, or valid inputV3NFTPermit must be provided with UR as spender
     */
    static migrateV3ToV4CallParameters(options: MigrateV3ToV4Options, positionManagerOverride?: string): MethodParameters;
    /**
     * Encodes a planned route into a method name and parameters for the Router contract.
     * @param planner the planned route
     * @param nativeCurrencyValue the native currency value of the planned route
     * @param config the router config
     */
    private static encodePlan;
}
